//*************************************************************************************************
//
//	Description:
//		Rendering of rain
//		
//		
//
//	<P> Copyright (c) 2007 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Matt Hobbs
//
//	History:
//
//	<TABLE>
//		\Author         Date        Version       Description
//		--------        -----       --------      ------------
//		Matt             10/08/2007  Created
//
//	<TABLE>
//
//*************************************************************************************************

#if defined(_XBOX) && !defined(_TOOLS_COMPILATION_)
#include "D:\Render\Shaders\stddefs.fxh"
#else
#include "..\..\..\Render\Shaders\stddefs.fxh"
#endif

#if defined(_PS3_)
#define _MINFILTER	LinearMipMapLinear
#define SET_NO_ANISOTROPY MaxAnisotropy = Aniso1;
#else
#define _MINFILTER	Linear
#define SET_NO_ANISOTROPY MaxAnisotropy = 1;
#endif



//-----------------------------------------------------------------------
//
// Constants
//

// The corner_vectors constant data is used to build the four corners of a quad.
float4 cornerVecTLTR
<
	bool appEdit = true;
> = { float4( -1, 1, 1, 1 ) };

float4 cornerVecBLBR
<
	bool appEdit = true;
> = { float4( -1, -1, 1, -1 ) };




//-----------------------------------------------------------------------
//
// Transforms
//
float4x4 worldviewproj : WorldViewProjection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
>;

float4x4 projMatrix : Projection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
>;



//-----------------------------------------------------------------------
//
// Textures
//
texture diffuseTexture : TEXTURE						
<
	string UIName = "Diffuse Texture";
	bool appEdit = true;
>;


// TODO: how are we going to set up 2 different textures for the 360 case, without needing a material file for 360 (texture params)
texture particlePosTex : TEXTURE						
<
	string UIName = "Particle Position";
	bool appEdit = true;
>;


//-----------------------------------------------------------------------
//
// Samplers
//

sampler2D diffuseMap : SAMPLER 
< 
	SET_SRGB_TEXTURE
	bool appEdit = false; 
	string SamplerTexture = "diffuseTexture"; 
	string MinFilter = "Linear";
	string MagFilter = "Linear";
	string MipFilter = "Linear";
	string AddressU  = "Clamp";
	string AddressV  = "Clamp";
>
= sampler_state
{
	Texture = < diffuseTexture >;
#if defined(SET_FX_SAMPLER_STATES)
	FX_SAMPLERSTATE_SRGB_TEXTURE
	MinFilter = _MINFILTER;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU  = Clamp;
	AddressV  = Clamp;
#endif
};

sampler2D particlePosMap : SAMPLER 
< 
	SET_LINEAR_TEXTURE
	bool appEdit = false; 
	string SamplerTexture="particlePosTex"; 
	string MinFilter = "Point";
	string MagFilter = "Point";
	string MipFilter = "Point";
	string AddressU  = "Clamp";
	string AddressV  = "Clamp";
> 
= sampler_state
{
	Texture = < particlePosTex >;
#if defined(SET_FX_SAMPLER_STATES)
	FX_SAMPLERSTATE_LINEAR_TEXTURE
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = Point;
	AddressU  = Clamp;
	AddressV  = Clamp;
#endif
};



//-----------------------------------------------------------------------
//
// Vertex Shader(s)
//

#if defined(_360_)
// 360 uses render to vertex buffer to create a stream of positions
struct VSINPUT
{
	int	vertexIndex : INDEX;
    float4 position  : POSITION;
    float2 texcoord	 : TEXCOORD0;
    float4 colour	 : COLOR0;
};

TTTTTTTTTTTTTT

#else
// PC - read positions as a vertex texture fetch
// (render to VB not possible under DX, though ATI does support a workaround using displacements maps)

// ps3 locks + updates VB on SPU
// TODO: stick vertex index in pos.w on PS3?
struct VSINPUT
{
	float4 particleData			: POSITION;
	float4 colour			    : COLOR0;
    float2 texcoord				: TEXCOORD0;
};
#endif

struct VSOUTPUT
{
    float4 position  : POSITION;
    float4 colour	 : TEXCOORD1;
    float2 texcoord	 : TEXCOORD0;
};



//-----------------------------------------------------------------------
//
// Vertex shader code
//

VSOUTPUT VShader( VSINPUT _input)
{
	VSOUTPUT _output;

	// get the index in [0..3] of the corner of this quad that the vertex represents (integer mod)
	int cornerIndex;	
	int vertexIndex;
#if defined(_360_)
	vertexIndex = _input.vertexIndex;	TTTTTTTTTTTTTT
#else
	vertexIndex = (int)_input.particleData.z;
#endif
	cornerIndex = vertexIndex / 4;
	cornerIndex = vertexIndex - (cornerIndex * 4);
	
	// TODO: extend renderer to allow setting of vec2's
	float2 corners[4];
	corners[0].x = cornerVecTLTR.x;
	corners[0].y = cornerVecTLTR.y;
	corners[1].x = cornerVecTLTR.z;
	corners[1].y = cornerVecTLTR.w;
	corners[2].x = cornerVecBLBR.x;
	corners[2].y = cornerVecBLBR.y;
	corners[3].x = cornerVecBLBR.z;
	corners[3].y = cornerVecBLBR.w;
	
	// get corner offset in clip space	
	float4 cornerOfs = mul( float4(corners[cornerIndex].x * 22.0, corners[cornerIndex].y * 22.0, 0.0f, 0.0f), projMatrix );

	// get centre position in clip space and combine with offset
	float4 centre;
#if defined(_360_)
	centre = float4( _input.position.xyz, 0.0f );TTTTTTTTTTTTTT
#else
	
	centre = float4( -62.0f, 1.0f, 28.7f, 0.0f );
	
	//centre = tex2D ( particlePosMap, _input.particleData.xy );
#endif	
	_output.position = mul( centre, worldviewproj );
	_output.position += cornerOfs;
	
	
	_output.colour.r = 1.0f;
	_output.colour.g = 0.0f;
	_output.colour.b = 0.0f;
	_output.colour.a = 1.0f;
	
	_output.texcoord = _input.texcoord;
	
	
	
    
    // TODO:
    //
    // col - stateless sim based on time alive + shader constant keys 
    // w/h - "" / read from w/h sim tex (keys to set speed and integrate)
    // other params that are stateless?
    //
    //
    
    return _output;
}



//-----------------------------------------------------------------------
//
// Fragment Shader(s)
//

struct PSINPUT
{
	float4 colour	: TEXCOORD1;
	float2 texCoord : TEXCOORD0;
};

struct PSOUTPUT
{
	COLOUR_OUTPUT_TYPE colour	: COLOR0;
};



//-----------------------------------------------------------------------
//
// Fragment shader code
//

PSOUTPUT fragmentShader( PSINPUT _input )
{
	PSOUTPUT _output;
	
    //_output.colour = tex2D( diffuseTexture, _input.texcoord );
    _output.colour = _input.colour;
    
    return _output;
}



//-----------------------------------------------------------------------
//
// Technique(s)
//

technique RenderGPUBillboards
<
	bool supportsSpecialisedLighting = false;
  bool preservesGlobalState = true;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "RenderGPUBillboards";
	int    normalDeferredID		= 2;
	string zprimeBehaviour		= "ERMB_DONT_RENDER";
	string zprimeDOFBehaviour	= "ERMB_DONT_RENDER";
	string shadowGenBehaviour = "ERMB_DONT_RENDER";
	string lowDetailBehaviour	= "ERMB_DONT_RENDER";
>
{
	pass Pass0
	{
#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx VShader();
		PixelShader = compile sce_fp_rsx fragmentShader();
#else
		VertexShader = compile vs_3_0 VShader();
		PixelShader = compile ps_3_0 fragmentShader();
#endif
	}
}